<?php
// Prevent direct access
if (!defined('ACCESS_ALLOWED')) {
    header('HTTP/1.0 403 Forbidden');
    exit;
}

// Get current year for copyright
$current_year = date('Y');
// Get school name from settings
$school_name = getSetting('school_name', 'Excel Academy');
?>

<footer class="footer">
    <div class="footer-content">
        <div class="footer-section">
            <h3><?php echo $school_name; ?></h3>
            <p>Student Fees Management System</p>
            <p>Version 2.0</p>
        </div>
        
        <div class="footer-section">
            <h4>Quick Links</h4>
            <ul>
                <li><a href="dashboard.php">Dashboard</a></li>
                <li><a href="students.php">Students</a></li>
                <li><a href="fees.php">Fees</a></li>
                <li><a href="reports.php">Reports</a></li>
            </ul>
        </div>
        
        <div class="footer-section">
            <h4>Support</h4>
            <ul>
                <li><a href="help.php">Help Center</a></li>
                <li><a href="contact.php">Contact Us</a></li>
                <li><a href="privacy.php">Privacy Policy</a></li>
                <li><a href="terms.php">Terms of Service</a></li>
            </ul>
        </div>
        
        <div class="footer-section">
            <h4>Contact Info</h4>
            <p><i class="material-icons">location_on</i> <?php echo getSetting('school_address', '123 Education Street'); ?></p>
            <p><i class="material-icons">phone</i> <?php echo getSetting('school_phone', '+234 801 234 5678'); ?></p>
            <p><i class="material-icons">email</i> <?php echo getSetting('school_email', 'info@example.com'); ?></p>
        </div>
    </div>
    
    <div class="footer-bottom">
        <p>&copy; <?php echo $current_year; ?> <?php echo $school_name; ?>. All rights reserved.</p>
        <p>Powered by Student Fees Management System</p>
    </div>
</footer>

<style>
.footer {
    background: linear-gradient(90deg, #2c3e50 0%, #34495e 100%);
    color: white;
    padding: 40px 0 20px;
    margin-top: auto;
}

.footer-content {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 30px;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
}

.footer-section h3,
.footer-section h4 {
    margin-bottom: 15px;
    color: #ecf0f1;
}

.footer-section p {
    margin-bottom: 10px;
    color: #bdc3c7;
}

.footer-section ul {
    list-style: none;
}

.footer-section ul li {
    margin-bottom: 8px;
}

.footer-section ul li a {
    color: #bdc3c7;
    text-decoration: none;
    transition: color 0.3s;
    display: flex;
    align-items: center;
}

.footer-section ul li a:hover {
    color: #3498db;
}

.footer-section i {
    margin-right: 8px;
    font-size: 16px;
}

.footer-bottom {
    border-top: 1px solid #4a5568;
    padding: 20px;
    text-align: center;
    margin-top: 30px;
}

.footer-bottom p {
    margin: 5px 0;
    color: #bdc3c7;
    font-size: 14px;
}

@media (max-width: 768px) {
    .footer-content {
        grid-template-columns: 1fr;
        text-align: center;
    }
    
    .footer-section ul li a {
        justify-content: center;
    }
}
</style>